/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.exceptions;

import java.io.IOException;
import java.util.Objects;

public final class UnsupportedFileVersionException
extends IOException {
    private static final long serialVersionUID = 1704594052564951970L;
    private final String fileVersion;

    public UnsupportedFileVersionException(String fileVersion) {
        super(String.format("Failed to read file data. Unsupported file version: %s.", fileVersion));
        this.fileVersion = fileVersion;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public final int hashCode() {
        return Objects.hash(this.fileVersion);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnsupportedFileVersionException other = (UnsupportedFileVersionException)obj;
        return Objects.equals(this.fileVersion, other.fileVersion);
    }
}

